;*****************************************************************************
;*                            PHASENANSCHNITT-STEUERUNG (TEST)               *
;*                              03.01.14                                     *
;*****************************************************************************

        LIST    P=12F675       
        TITLE   "PHASE"

        ERRORLEVEL -302
        INCLUDE <P12F675.INC>

__CONFIG _HS_OSC & _WDT_OFF & _PWRTE_OFF & _BODEN_OFF & _MCLRE_OFF & _CPD_OFF & _CP_OFF





;------------------------- MACROS -----------------------------------------

BANK0                   MACRO                   ;MACRO TO SELECT DATA RAM BANK 0
                        BCF     STATUS,RP0
                        ENDM
;----------------------------------------------------------------------------
BANK1                   MACRO                   ;MACRO TO SELECT DATA RAM BANK 1
                        BSF     STATUS,RP0
                        ENDM
;----------------------------------------------------------------------------

;VARIABLEN
BIT0        EQU 0
BIT1        EQU 1
BIT2        EQU 2
BIT3        EQU 3
BIT4        EQU 4
BIT5        EQU 5
BIT6        EQU 6
BIT7        EQU 7

;--------------------------------------------------------------------------
;REGISTER ZUORDNEN NACH DEM DIE FESTEN-REGISTER ZU ENDE SIND
;ES GEHT ALSO ERST AB 22 HEX LOS
;DIES IST ALSO DIE RAM-SPEICHER ZUORDNUNG

MERK                    EQU     0X22             
ZAE                     EQU     0X23
AD_H                    EQU     0X24
AD_L                    EQU     0X25
HELP                    EQU     0X26
;BIT0 BEI HIGH -->NCHSTER AD-WERT GRSSER / ANSTEIGENDE SINUSFLANKE KURZ NACH DEM NULLPUNKT MIT NULL VOLT
;BIT1 BEI HIGH -->WAR VORHERIGER DA UND ABGESPEICHERT / UNTERHALB 400MVOLT

VORHER                  EQU     0X27
ZEIT_L                  EQU     0X28
ZEIT_H                  EQU     0X29

;--------------------------------------------------------------------------


;SPEICHERANFANG BZW. BEGINN
    ORG 0X0000
    GOTO MAIN           ; SPRUNG ZUM HAUPTPROGRAMM
    ORG 0X0004
    RETFIE              ; KEIN INTERRUPT

    ORG 0X0010
;*****************************************************************************
;*                            HAUPTPROGRAMM                                  *
;*                              26.12.13                                     *
;*****************************************************************************
;PORT-INITIALISIERUNG
MAIN                    BANK0
                        CLRF    GPIO     
                        MOVLW   0X07                        ;COMPARATORS ALLE AUS 
                        MOVWF   CMCON

                        BANK1
;INIT TIMER 0 FUER 10MSEC FUER ZEITSCHLEIFE 
;(HIER MUSS MAN IN DEM DATENBLATT (DATASHEET) BEI WWW.MICROCHIP.COM (EIN *.PDF-FILE) NACHSEHEN, WIE ALLES FUNKTIONIERT)
                        MOVLW   B'10000111'                 ;BIT0-2 111=PRESCALER256, BIT3 0=TMR0, BIT4 0=ENTFAELLT, BIT5 0=TAKT VOM SYSTEM, BIT6 0=KEIN RB-INTERRUPT, BIT7 1=PULL-UPS DISABLE 
                        MOVWF   OPTION_REG      

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                        MOVLW   B'00010011'                 ;ANALOG/DIGITAL
                        MOVWF   ANSEL                       ;GP2 + GP3 DIGITAL I/O     AN0 + AN1 -ANALOG/DIGITAL WANDLER MIT QUARZ-TAKT-INTERN  1/8-TEL
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                        MOVLW   B'11111011'                 ;GP2 ALS AUSGANG (ALSO HIER DIE 0), SONST ALLES EINGNGE (ALSO IMMER DIE (1))
                        MOVWF   TRISIO
                        BANK0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;INITIALISIERUNG--ZU--ENDE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                    CLRF    HELP
                    CALL    AUS

                    MOVLW   D'100'          ;ZEITSCHLEIFE FUER 1SEC EINGESTELLT    100*10MSEC=1000MSEC=1SEC
                    CALL    ZS10MSEC        ;UM EINSCHALTIMPULS ZU UNTERDRUECKEN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


ANFANG              CALL    NULL_PHASE
                    BTFSS   HELP, BIT0      ;BEI HIGH IST NULLDURCHGANG ERKANNT
                    GOTO    ANFANG


      
;AD-MESSUNG AM POTI AN   AN1(PIN6), WIE LANGE DIE IMPULSZEIT NACH DER STEIGENDEN FLANKE , NACH DEM NULL-DURCHGANG SEIN SOLL
;ALSO DIE VERZGERUNG NACH DEM NULL-DURCHGANG

                    CALL    ZEIT_AD



;----------------------------------
;MIT FESTER ZEIT (AD-WERTEN) ERST MAL PROBIEREN
;MOVLW 0X01
;MOVWF ZEIT_L
;MOVLW 0X01
;MOVWF ZEIT_H
;----------------------------------


;VERZOEGERUNG VON MAX.10MSEC
;ZEITSCHLEIFE OBEN
;10MSEC : 1024 = 9,765SEC
;HIER VORERST GENOMMEN 6SEC

ANF                     MOVLW   D'6'
                        CALL    ZS1MUE

;ZS1MUE NACH MAXIMAL 10MSEC BEENDET
                        DECFSZ  ZEIT_L, F       ;DURCHLUFE ABWRTS ZHLEN AUS CALL ZEIT_AD AM POTI BERECHNET !
                        GOTO    ANF
                        DECFSZ  ZEIT_H, F
                        GOTO    ANF


;IMPULS WEGBLENDEN MIT TASTER ODER SCHALTER
                        BTFSS   GPIO, GP3
                        GOTO    KEINE_LAMPE


;IMPULS AUSGEBEN
                        CALL    EIN             ;40SEC IMPULS FR OPTOKOPPLER
                        MOVLW   D'40'
                        CALL    ZS1MUE
                        CALL    AUS

KEINE_LAMPE             CLRF    HELP
                        GOTO    ANFANG





;*****************************************************************************
;*                              AD-MESSEN                                    *
;*                              26.08.13                                     *
;*****************************************************************************
NULL_PHASE      MOVLW   B'10000000' ;ADMF=1 RECHTSBNDIG, VDD ALS REF, CHANNEL AN0, NO GO BIT1, NO ADON BIT0
                MOVWF   ADCON0

NOCHMAL         BCF     PIR1, ADIF

;ANALOG/DIGITAL-WANDLUNG STARTEN
                BSF     ADCON0, ADON        
                MOVLW   D'40'
                CALL    ZS1MUE              ;ZEITSCHLEIFE
                BSF     ADCON0, GO_DONE     ;GEHT LOS

I2              BTFSS  PIR1, ADIF
                GOTO   I2

;ANALOG/DIGITAL-WANDLUNG STOPPEN
                BCF     ADCON0, ADON        
                BCF     ADCON0, GO_DONE    


;AD-ERGEBNIS ABSPEICHERN IN RAM-ZELLEN
                MOVF    ADRESH, W
                MOVWF   AD_H
                BANK1
                MOVF    ADRESL, W
                BANK0
                MOVWF   AD_L

;BERECHNUNG
;1024=5VOLT
;X   =500MVOLT
;-------------
;X= (1024*500MV) : 5V
;X= 102
;KLEINER 500MVOLT = D'102' ERST DANN WEITER SIEHE UNTEN BEI JETZT D'72'

;AD-HIGH ZUERST KONTROLLIEREN
                MOVLW   0X00
                SUBWF   AD_H, W
                BTFSS   STATUS, Z
                RETURN

;DANN AD-LOW KLEINER XXX MVOLT KONTROLLIEREN
                MOVLW   D'72'                ;GEHT AUF 22VOLT ALS MINIMUM  RUNTER 
                SUBWF   AD_L, W
                BTFSC   STATUS, C
                RETURN

;VORHERIGEN WERT SPEICHERN UND
;DANN NACHSEHEN OB DER NCHSTE GRSSER IST.
;DANN IST MAN AM ANFANG EINER STEIGENDEN 220VOLT HALBWELLE
                BTFSS   HELP, BIT1
                GOTO    ERSTER_WERT

                MOVF    VORHER, W
                SUBWF   AD_L, W
                BTFSS   STATUS, C
                GOTO    ERSTER_WERT

                BSF     HELP, BIT0      ;JETZT IST DER VORHERIGE WERT KLEINER ODER DER JETZIGE GROESSER
                RETURN

ERSTER_WERT     MOVF    AD_L, W
                MOVWF   VORHER
                BSF     HELP, BIT1
                RETURN

;*****************************************************************************
;*                              AD-MESSEN                                    *
;*                              26.08.13                                     *
;*****************************************************************************
ZEIT_AD
                MOVLW   B'10000100' ;ADMF=1 RECHTSBNDIG, VDD ALS REF, CHANNEL AN1, NO GO BIT1, NO ADON BIT0
                MOVWF   ADCON0

                BCF     PIR1, ADIF

;ANALOG/DIGITAL-WANDLUNG STARTEN
                BSF     ADCON0, ADON        
                MOVLW   D'40'
                CALL    ZS1MUE              ;ZEITSCHLEIFE
                BSF     ADCON0, GO_DONE     ;GEHT LOS

I1              BTFSS  PIR1, ADIF
                GOTO   I1

;ANALOG/DIGITAL-WANDLUNG STOPPEN
                BCF     ADCON0, ADON        
                BCF     ADCON0, GO_DONE    


;AD-ERGEBNIS ABSPEICHERN IN RAM-ZELLEN
                MOVF    ADRESH, W
                MOVWF   ZEIT_H
                BANK1
                MOVF    ADRESL, W
                BANK0
                MOVWF   ZEIT_L

                        INCF    ZEIT_H, F     ;MUSS SO SEIN !!!!!!!!!!

                        MOVF    ZEIT_L, W     ;AD_L    --> W
                        SUBLW   0X00          ;0X00-W  --> W
                        BTFSC   STATUS, Z
                        INCF    ZEIT_L, F     ;BEI 0X00 UM 1 ERHHEN SONST ERGIBT SICH 256

                        RETURN

;*****************************************************************************
;*                              CW-EIN                                       *
;*                              04.05.12                                     *
;*****************************************************************************
EIN
    BSF     GPIO, GP2
    RETURN

;*****************************************************************************
;*                              CW-AUS                                       *
;*                              04.05.12                                     *
;*****************************************************************************
AUS
    BCF     GPIO, GP2
    RETURN

;*****************************************************************************
;*                              40SEC ZEITSCHLEIFE                          *
;*                              03.01.14                                     *
;*****************************************************************************

;1SEC : 0,0625SEC = 16T MUESSEN ES SEIN FR EINE SEC

ZS1MUE      MOVWF   ZAE     ;        1T=0,0625SEC
MUE         NOP             ;4T
            DECFSZ  ZAE, F  ;4T
            GOTO    MUE     ;8T
            RETURN

;*****************************************************************************
;*                              10MSEC ZEITSCHLEIFE                          *
;*                              03.01.14                                     *
;*****************************************************************************
ZS10MSEC                MOVWF   MERK

ZZ01                    MOVLW   D'100'
                        MOVWF   TMR0                    ;DER FESTE RAM-SPEICHER (TMR0) WIRD MIT 61 GELADEN
                        BCF     INTCON, T0IF            ;OVERFLOW = 0
                
ZZ02                    BTFSS   INTCON, T0IF            ;WENN DIE ZEIT VON 50MSEC ABGELAUFEN IST, WIRD T0IF HIGH (1) UND 
                        GOTO    ZZ02                    ;ES ERFOLGT EIN SPRUNG ZU "DECFSC MERK, F"..... VORHER ANDERES ABARBEITEN

                        DECFSZ  MERK, F                ;ES WIRD DER WERT IN "MERK" ABWRTS GEZHLT, BIS ER (0) IST UND
                        GOTO    ZZ01                   ;DANN ERFOLGT EIN SPRUNG ZU "RETURN"-ENDE DES UNTERPROGRAMMS

                        RETURN

;ZEITBERECHNUNG FUER 10MS
;(HIER MUSS MAN IN DEM DATENBLATT (DATASHEET) BEI WWW.MICROCHIP.COM (EIN *.PDF-FILE) NACHSEHEN, WIE ALLES FUNKTIONIERT)

;PRESCALER 256X  *  SYSTEM 4X  * TAKTZEIT ====> 256*4*0.0625S=64S   /DIE TAKTZEIT ERGIBT SICH AUS DEM INTERNEN OSZILLATOR
;10MS : 64S= 156                                                    /T = 1 : F  (F)-OSZILLATORFREQUENZ HIER 16MHZ
;ALSO
;64S*D'156'=CA.10MSEC
;TMR0 ALSO D'256'-D'156'=D'100' ENTSPRICHT CA. 10MSEC
;100 DEZIMAL OBEN EINTRAGEN

                        END

